<?LassoScript

	// This page allows the administrator to create a section in the site including
	// the site's title, header, and footer and the ordering of pages in the section.

	if: ($action >> 'create');
	
		// Create the section's record.

		// Store the section title, header, footer, code, and status in variables.
		var: 'section_header' = (action_param: 'section_header');
		var: 'section_footer' = (action_param: 'section_footer');
		var: 'section_title' = (action_param: 'section_title');
		var: 'section_code' = (action_param: 'section_code');
		var: 'section_status' = ((action_param: 'section_status') >> 'N' ? 'N' | 'Y');
	
		// Create a section code and title if none was provided
		if: $section_code == '';
			var: 'section_code' = (string_replaceregexp: $section_title, -find='\\s+', -replace='_')->(substring: 0, 8);
		/if;
		if: $section_title == '';
			var: 'section_title' = 'Untitled Section';
		/if;
		
		// Check that the section code is unique
		inline: -log=$log_level,
				-search,
				-database='op_collaborate',
				-table='sections',
				-keyfield='id',
				-op='eq', 'code'=$section_code,
				-maxrecords=1, -uselimit,
				-returnfield='id';
			if: (found_count == 1);
				var: 'section_code' = '';
			/if;
		/inline;
		
		// Use a default section code if necessary
		if: $section_code == '';
			var: 'section_code' = lasso_uniqueid;
		/if;
		
		// Store the preferences in the preference map.  Any action parameters which start with
		// 'prefs_' are inserted into a map.  This map is then serialized into the database.
		
		var: 'prefs' = (map);
		iterate: action_params, (var: 'temp');
			var: 'key' = $temp->first;
			var: 'value' = $temp->second;
			if: $key->(beginswith: 'prefs_');
				$key -= 'prefs_';
				$prefs->(insert: $key = $value);
			/if;
		/iterate;
		
		// Add the record to the database
		
		inline: -log=$log_level,
				-add,
				-database='op_collaborate',
				-table='sections',
				-keyfield='id',
				'code'=(var: 'section_code'),
				'title'=(var: 'section_title'),
				'header'=(var: 'section_header'),
				'footer'=(var: 'section_footer'),
				'sort'=32768,
				'prefs'=$prefs->serialize;
			if: (error_msg == error_noerror);
				var: 'handled' = false;
				var: 'section' = (var: 'section_code');
			/if;
		/inline;


	else: $action >> 'cancel';

		// Cancel the add.  The user is returned to the site edit page.

		var: 'section' = '';
		var: 'mode' = 'edit';
		var: 'handled' = false;		

	else;

		// If there is no action, set 'handled' to true so the remainder of the page will show.

		var: 'prefs' = (map);
		var: 'handled' = true;		

	/if;
	

	// Define a set of helper tags.  Each tag outputs a checkbox with a clickable
	// label which allows a new color, font family, or font size to be chosen.  By
	// defining these custom tags the code for each of the checkboxes can be modified
	// in one place.
	
	var: 'stylePicker_id' = 0;
	define_tag: 'colorPicker', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a color name or hex value (e.g. #FFFFFF or white):\',\'color\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="color: ' + $prefs->(find: #name) + ';"') + '>' + #label + '</a>';
		return: @#output;
	/define_tag;
	define_tag: 'fontPicker', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a font family name (e.g. Verdana or Arial):\',\'font-family\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="font-family: ' + $prefs->(find: #name) + ';"') + '>' + (if_null: $prefs->(find: #name),#label) + '</a>';
		return: @#output;
	/define_tag;
	define_tag: 'fontSizer', -required='name', -required='label', -optional='addl';
		$stylePicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="stylePicker_' + $stylePicker_id + '" value="' + $prefs->(find: #name) + '"' + (($prefs->keys >> #name)?' checked="checked"') + ' /> <a href="" onclick="return stylePicker(this,\'stylePicker_' + $stylePicker_id + '\',\'Type a font size (e.g. 12px or large):\',\'font-size\',\'' + (local: 'addl') + '\');"' + (($prefs->keys >> #name)?' style="font-size: ' + $prefs->(find: #name) + ';"') + '>' + (if_null: $prefs->(find: #name),#label) + '</a>';
		return: @#output;
	/define_tag;

	// The remainder of the page shows a form to the user which includes options
	// for the title, header, footer, status, and code for the section and font style
	// preferences for the header and footer.

?>

[if: $handled == true]

<h2>Collaborate</h2>
<div class="group_list" id="page_frame"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
	<div class="group"><b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
		<div class="group_title">
			<a href="index.lasso">Home</a> &gt; 
			New Section
		</div>
		<div class="wrap">
		<div class="nav">
			[include: 'edit/nav.lasso']
		</div>
			<form action="edit.lasso" method="post">
				<div class="page">
					<input type="hidden" name="mode" value="edit" />
					<input type="hidden" name="section" value="[var: 'section']" />
					<input type="hidden" name="page" value="[var: 'page']" />
					<table>
						<tr>
							<th>Section Title</th>
							<td><input type="text" name="section_title" value="[var: 'section_title']" /></td>
						</tr>
						<tr>
							<th>Section Code</th>
							<td><input type="text" name="section_code" value="[var: 'section_code']" /></td>
						</tr>
						<tr>
							<th>Section Status</th>
							<td><select name="section_status">
								<option value="Y"[if: (var: 'section_status') != 'N'] selected="selected"[/if]>Visible</option>
								<option value="N"[if: (var: 'section_status') == 'N'] selected="selected"[/if]>Hidden</option>
							</select></td>
						</tr>
						<tr>
							<th>Section Header</th>
							<td>
								<textarea name="section_header" cols="40" rows="4">[var: 'section_header']</textarea>
								<br />[colorPicker: 'section_header_color','Text Color']
								[fontPicker: 'section_header_fontfamily','Font Family']
								[fontSizer: 'section_header_fontsize','Font Size']
								<br /><input type="checkbox" name="prefs_section_header_fontweight" value="bold"[if: ($prefs->(find: 'section_header_fontweight') == 'bold')] checked="checked"[/if] /> <span style="font-weight: bold">Bold</span>
								<input type="checkbox" name="prefs_section_header_fontstyle" value="italic"[if: ($prefs->(find: 'section_header_fontstyle') == 'italic')] checked="checked"[/if] /> <span style="font-style: italic">Italic</span>
								<input type="checkbox" name="prefs_section_header_fontvariant" value="small-caps"[if: ($prefs->(find: 'section_header_fontvariant') == 'small-caps')] checked="checked"[/if] /> <span style="font-variant: small-caps">Small Caps</span>
								<br /><input type="radio" name="prefs_section_header_textalign" value="left"[if: ($prefs->(find: 'section_header_textalign') == 'left')] checked="checked"[/if] /> Left
								<input type="radio" name="prefs_section_header_textalign" value="center"[if: ($prefs->(find: 'section_header_textalign') == 'center')] checked="checked"[/if] /> Center
								<input type="radio" name="prefs_section_header_textalign" value="right"[if: ($prefs->(find: 'section_header_textalign') == 'right')] checked="checked"[/if] /> Right
							</td>
						</tr>
						<tr>
							<th>Section Footer</th>
							<td>
								<textarea name="section_footer" cols="40" rows="4">[var: 'section_footer']</textarea>
								<br />[colorPicker: 'section_footer_color','Text Color']
								[fontPicker: 'section_footer_fontfamily','Font Family']
								[fontSizer: 'section_footer_fontsize','Font Size']
								<br /><input type="checkbox" name="prefs_section_footer_fontweight" value="bold"[if: ($prefs->(find: 'section_footer_fontweight') == 'bold')] checked="checked"[/if] /> <span style="font-weight: bold">Bold</span>
								<input type="checkbox" name="prefs_section_footer_fontstyle" value="italic"[if: ($prefs->(find: 'section_footer_fontstyle') == 'italic')] checked="checked"[/if] /> <span style="font-style: italic">Italic</span>
								<input type="checkbox" name="prefs_section_footer_fontvariant" value="small-caps"[if: ($prefs->(find: 'section_footer_fontvariant') == 'small-caps')] checked="checked"[/if] /> <span style="font-variant: small-caps">Small Caps</span>
								<br /><input type="radio" name="prefs_section_footer_textalign" value="left"[if: ($prefs->(find: 'section_footer_textalign') == 'left')] checked="checked"[/if] /> Left
								<input type="radio" name="prefs_section_footer_textalign" value="center"[if: ($prefs->(find: 'section_footer_textalign') == 'center')] checked="checked"[/if] /> Center
								<input type="radio" name="prefs_section_footer_textalign" value="right"[if: ($prefs->(find: 'section_footersection_footer_textalign') == 'right')] checked="checked"[/if] /> Right
							</td>
						</tr>
					</table>
					<p>
						<input type="submit" name="action" value="Create Section" />
						<input type="submit" name="action" value="Cancel" />
					</p>
				</div>
			</form>
			<!-- This div forces the background color to extend the length of the navigation -->
			<div style="clear: both;"><br /></div>
		</div>
	</div>
	<div class="group">
		<div class="group_title"><a href="index.lasso">View This Site</a></div>
	</div>
</div>

[/if]
